<?php declare(strict_types = 1);

namespace Core\Model;

/**
 * Class SystemConfig
 * @package Core\Model
 */
class SystemConfig
{
	/** @var array */
	protected $params;

	/** @var string */
	protected $separator = '.';

	/**
	 * SystemConfig constructor.
	 *
	 * @param $params
	 */
	public function __construct($params)
	{
		$this->params = $params;
	}

	/**
	 * @param string $key
	 * @param mixed  $default
	 *
	 * @return mixed|null
	 */
	public function get($key, $default = null)
	{
		$keys = explode($this->separator, $key);
		$arr  = $this->params;

		foreach ($keys as $key) {
			if (!isset($arr[$key]))
				return $default;
			$arr = &$arr[$key];
		}

		return $arr ?? $default;
	}
}
