<?php declare(strict_types=1);

namespace Core\Model\UI\Form\Controls;

use libphonenumber\NumberParseException;
use libphonenumber\PhoneNumberUtil;
use Nette\Forms\Form;
use Nette\NotSupportedException;

class PhoneInput extends TextInput
{
    private $phoneUtil;

    public function __construct($label = null, $maxLength = null)
    {
        if ($maxLength !== null) {
            throw new NotSupportedException('Do not set $maxLength!');
        }
        parent::__construct($label, null);

        $this->control->type = 'tel';
        $this->setOption('type', 'tel');

        $this->phoneUtil = PhoneNumberUtil::getInstance();

        $this->addRule(function($input) {
            try {
                $phoneParsed = $this->phoneUtil->parse($input->value, 'CZ');
                $valid = $this->phoneUtil->isValidNumber($phoneParsed);
            } catch (NumberParseException $e) {
                $valid = false;
            }

            return $valid;
        }, 'default.formMessages.phone')
        ->addRule(Form::PATTERN, 'default.formMessages.phone_min', '(.*\d.*){9}'); //pro JS validaci - minimalne 9 cislic

        $this->setPlaceholder('123456789');
    }

}
