<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="core__country")
 * @ORM\Entity
 */
class Country
{
	use MagicAccessors;

	/**
	 * @var string
	 *
	 * @ORM\Id
	 * @ORM\Column(name="`id`", type="string", length=255, nullable=false)
	 */
	public $id;

	/**
	 * @var string
	 * @ORM\Column(name="`name`", type="string", length=255, nullable=true)
	 */
	public $name;
	
	/**
	 * @var int
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	protected $position;

	/**
	 * Country constructor.
	 *
	 * @param string $id
	 * @param string $name
	 */
	public function __construct(string $id, string $name)
	{
		$this->id   = $id;
		$this->name = $name;
		$this->setPosition(-1);
	}
	
	public function getId()
	{
		return $this->id;
	}
	
	public function getName()
	{
		return $this->name;
	}
	
	public function setName($name): Country
	{
		$this->name = $name;
		return $this;
	}
	
	public function getPosition()
	{
		return $this->position;
	}
	
	public function setPosition($position): Country
	{
		$this->position = $position;
		return $this;
	}
	
	
}
