<?php declare(strict_types=1);

namespace Core\Model\Translation\Utils;

use Core\Model\Helpers\Strings;
use Core\Model\SystemConfig;

class Helpers
{
	/**
	 * @param string $domain
	 * @param array|null $rules
	 * @return bool
	 */
	public static function isDomainAllowed(string $domain, array $rules = null): bool
	{
		$rules = $rules ?? SystemConfig::load('staticTextsTranslation.domains');

		foreach ($rules as $key => $all) {
			switch ($key) {
				case 'startsWith':
					foreach ($all as $needle) {
						if (Strings::startsWith($domain, $needle)) {
							return true;
						}
					}
					break;
				case 'contains':
					foreach ($all as $needle) {
						if (Strings::contains($domain, $needle)) {
							return true;
						}
					}
					break;
			}
		}
		return false;
	}
}