<?php declare(strict_types = 1);

namespace Core\Model\UI;

use Core\Model\Event\ControlEvent;

abstract class ErrorPresenter extends AbstractPresenter
{
	protected function startup()
	{
		parent::startup();
		$this->eventDispatcher->dispatch(new ControlEvent($this), self::class . '::startup');
	}

	public function beforeRender()
	{
		parent::beforeRender();
		$this->eventDispatcher->dispatch(new ControlEvent($this), self::class . '::beforeRender');
	}
}
