<?php declare(strict_types = 1);

namespace Core\Console\Cache;

use Contributte\Application\LinkGenerator;
use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use Kdyby;
use Nette\Caching\Cache;
use Nette\Caching\IStorage;
use Nette\Utils\FileSystem;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Tracy\Debugger;

/**
 * Class Clean
 * @package Core\Console\Cache
 */
class Clean extends AbstractCommand
{
	/** @var IStorage @inject */
	public $cacheStorage;

	protected function configure()
	{
		$this->setName('cache:clean')->setDescription('Generate eshop catalog cache');
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, Doctrine\ORM\Tools\SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui)
	{
		$output->writeln('CLEAN CACHE');

		try {
			$cache = new Cache($this->cacheStorage);
			$cache->clean([Cache::ALL => true]);
			FileSystem::delete(TMP_DIR);
			FileSystem::createDir(TMP_DIR);

			$output->writeLn('<info>[OK]</info>');
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}
	}
}
