<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="core__redirect")
 * @ORM\Entity
 */
class Redirect
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255, nullable=false)
	 */
	public $title;

	/**
	 * @var string
	 * @ORM\Column(name="`from`", type="string", length=255, nullable=false)
	 */
	public $from;

	/**
	 * @var string
	 * @ORM\Column(name="`to`", type="string", length=255, nullable=false)
	 */
	public $to;

	/**
	 * @var int
	 * @ORM\Column(name="is_locked", type="smallint", nullable=false, options={"default": 0})
	 */
	public $isLocked;

	/**
	 * @var string
	 * @ORM\Column(name="`package`", type="string", length=255, nullable=true)
	 */
	public $package;

	/**
	 * @var string
	 * @ORM\Column(name="relation_key", type="string", length=255, nullable=true)
	 */
	public $relationKey;

	/**
	 * @var string
	 * @ORM\Column(name="relation_value", type="string", length=255, nullable=true)
	 */
	public $relationValue;

	/**
	 * @var string
	 * @ORM\Column(name="redirect_code", type="string", length=255, nullable=false, options={"default": "301"})
	 */
	public $redirectCode;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint", nullable=false, options={"default": 1})
	 */
	public $isPublished;

	/**
	 * @var int
	 * @ORM\Column(name="views", type="integer", nullable=false, options={"default": 0})
	 */
	public $views;

	/**
	 * @var array
	 * @ORM\Column(name="params", type="array", nullable=true)
	 */
	private $params;

	public function __construct($title, $from, $to)
	{
		$this->title        = $title;
		$this->from         = $from;
		$this->to           = $to;
		$this->isLocked     = 0;
		$this->redirectCode = 301;
		$this->isPublished  = 1;
		$this->params       = [];
		$this->views        = 0;
	}

	/******
	 * === Params
	 */

	public function getParams() { return $this->params ?: []; }

	public function getParam($key) { return $this->params[$key] ?? null; }

	public function setParam($key, $value)
	{
		if ($value) {
			$this->params[$key] = $value;
		} else {
			unset($this->params[$key]);
		}
	}
}
