<?php declare(strict_types = 1);

namespace Core\Model\UI;

use Core\Model\Event\ControlEvent;

abstract class AdminPresenter extends AbstractPresenter
{
	protected function startup()
	{
		$this->eventDispatcher->dispatch(new ControlEvent($this), self::class . '::startup');
		parent::startup();
	}

	public function beforeRender()
	{
		$this->eventDispatcher->dispatch(new ControlEvent($this), self::class . '::beforeRender');
		parent::beforeRender();
	}

}
