<?php declare(strict_types = 1);

namespace Core\Model\UI;

use Core\Model\Event\ControlEvent;
use Core\Model\Providers\BaseComponentPack;
use Nette\ComponentModel\IComponent;

abstract class FrontPresenter extends AbstractPresenter
{
	/** @var IComponent[][] */
	protected array $componentsPack = [
		'head'      => [],
		'bodyStart' => [],
		'bodyEnd'   => [],
	];

	protected function startup()
	{
		$this->eventDispatcher->dispatch(new ControlEvent($this), self::class . '::startup');
		parent::startup();
	}

	public function beforeRender()
	{
		$this->eventDispatcher->dispatch(new ControlEvent($this), self::class . '::beforeRender');
		parent::beforeRender();
	}

	protected function tryCall($method, array $params)
	{
		$result = parent::tryCall($method, $params);

		if (strpos($method, 'render') === 0) {
			$this->template->componentsPack = $this->componentsPack;
		}

		return $result;
	}

	public function addHeadComponent(IComponent $component, ?string $name): void
	{
		$this->addToComponentsPack($component, 'head', $name);
	}

	public function addBodyStartComponent(IComponent $component, ?string $name): void
	{
		$this->addToComponentsPack($component, 'bodyStart', $name);
	}

	public function addBodyEndComponent(IComponent $component, ?string $name): void
	{
		$this->addToComponentsPack($component, 'bodyEnd', $name);
	}

	protected function addToComponentsPack(IComponent $component, string $position, ?string $name): void
	{
		$name = $name ?: $component->getName();

		if ($component instanceof BaseComponentPack) {
			$component->setRenderFile($position);
		}

		$this->addComponent($component, $name . '_' . $position);
		$this->componentsPack[$position][$name] = $component;
	}

	public function getBodyEndComponentsPack(): array
	{
		$this->eventDispatcher->dispatch(new ControlEvent($this), self::class . '::getBodyEndComponentsPack');

		return $this->componentsPack['bodyEnd'];
	}
}
