CKEDITOR.plugins.add('filemanager', {
	icons: 'filemanager',
	init: function (editor) {
		editor.addCommand('openFileManager', {
			exec: function (editor) {
				var $textarea = $('#' + editor.name);
				if ($textarea.length && $textarea.attr('data-roots') != undefined) {
					$.each(JSON.parse($textarea.attr('data-roots')), function (i, v) {
						if (typeof i === "string")
							editor.config.fileManagerData.roots[i] = v;
						else
							editor.config.fileManagerData.roots.push(v);
					});
				}

				$.nette.ajax({
					method: 'post',
					url: editor.config.fileManagerUrl,
					data: editor.config.fileManagerData,
				});
			}
		});
		editor.addCommand('insertImage', {
			exec: function (editor, data) {
				editor.insertHtml('<img src="' + data.url + '">');
			}
		});
		editor.ui.addButton('FileManager', {
			label: 'Open filemanager',
			command: 'openFileManager',
			toolbar: 'editor'
		});
	}
});