<?php declare(strict_types = 1);

namespace Core\Model;

/**
 * Class SystemConfig
 * @package Core\Model
 */
class SystemConfig
{
	/** @var array */
	protected static $params;

	/** @var string */
	protected static $separator = '.';

	/**
	 * SystemConfig constructor.
	 *
	 * @param $params
	 */
	public function __construct($params)
	{
		self::$params = $params;
	}

	/**
	 * TODO nahradit statickou metodou load
	 *
	 * @param string $key
	 * @param mixed  $default
	 *
	 * @return mixed|null
	 */
	public function get($key, $default = null)
	{
		$keys = explode(self::$separator, $key);
		$arr  = self::$params;

		foreach ($keys as $key) {
			if (!isset($arr[$key]))
				return $default;
			$arr = &$arr[$key];
		}

		return $arr ?? $default;
	}
	
	public static function load($key, $default = null)
	{
		$keys = explode(self::$separator, $key);
		$arr  = self::$params;

		foreach ($keys as $key) {
			if (!isset($arr[$key]))
				return $default;
			$arr = &$arr[$key];
		}

		return $arr ?? $default;
	}
}
