<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Core\Model\SystemConfig;
use libphonenumber\NumberParseException;
use libphonenumber\PhoneNumberUtil;
use Nette\Forms\Form;
use Nette\NotSupportedException;

class PhoneInput extends TextInput
{
	private $phoneUtil;

	protected $regionRuleIsSet = false;

	protected $region;

	public function __construct($label = null)
	{
		parent::__construct($label, null);

		$this->control->type = 'tel';
		$this->setOption('type', 'tel');

		$this->phoneUtil = PhoneNumberUtil::getInstance();
		$this->region    = SystemConfig::load('phoneInputRegions');

		$this->setPlaceholder('123456789');
	}

	public function setRegion($region)
	{
		$this->region = $region;
	}

	public function validate()
	{
		if (!$this->regionRuleIsSet) {
			$this->addRule(function($input) {
				try {
					$regions = $this->region;
					if (!is_array($regions))
						$regions = [$regions];

					$valid = false;
					foreach ($regions as $region) {
						$phoneParsed = $this->phoneUtil->parse($input->value, $region);
						$valid       = $this->phoneUtil->isValidNumber($phoneParsed);

						if ($valid)
							break;
					}
				} catch (NumberParseException $e) {
					$valid = false;
				}

				return $valid;
			}, 'default.formMessages.phone');
		}
		$this->addRule(Form::PATTERN, 'default.formMessages.phone_min', '(.*\d.*){9}'); //pro JS validaci - minimalne 9 cislic

		return parent::validate();
	}

}
