<?php declare(strict_types = 1);

namespace Core\ErrorModule\Presenters;

use Core\Components\Navigation\INavigationFactory;
use Core\ErrorModule\Presenters\CustomBasePresenter;
use Navigations\Model\Navigations;

abstract class BasePresenter extends CustomBasePresenter
{
	/** @var Navigations @inject */
	public $navigationsService;

	protected function startup()
	{
		parent::startup();
		$this['meta']->setMeta('robots', 'noindex,nofollow');
		$this['title']->setTitle($this->translator->translate('default.errorPage.title'));
	}

	protected function createComponentNavigation(INavigationFactory $factory)
	{
		$control = $factory->create();
		$control->setData($this->navigationsService->getPublishedDaoNavigationStructure());

		return $control;
	}
}
