<?php declare(strict_types = 1);

namespace Core\AdminModule\Components\Country;

use Nette\Utils\ArrayHash;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Core\Model\Countries;
use Core\Model\Entities\Country;

class CountryForm extends BaseControl
{
	/** @var Country */
	protected $country;
	
	/** @var Countries */
	protected $countriesService;
	
	public function __construct(Countries $countries)
	{
		$this->countriesService = $countries;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ======================== COMPONENTS
	 */

	protected function createComponentForm()
	{
		$form = $this->createForm();
		$form->setAjax();
		
		$form->addText('name', 'default.name2')->setRequired()->setMaxLength(255);
		$form->addText('id', 'admin.countryForm.idCountry')->setMaxLength(255);
		$form->addSaveCancelControl('saveControl');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		$this->em->beginTransaction();
		try {
			if ($this->country) {
				$country       = $this->country;
				$country->setName($values->name);
			} else {
				$country       = new Country($values->id, $values->name);
			}
			
			$this->em->persist($country)->flush();
			
			$form->addCustomData('countryId', $country->getId());
			
			$presenter = $this->getPresenter();
			$presenter->flashMessageSuccess('default.saved');
			$presenter->redrawControl('flashes');

			$this->em->commit();
		} catch (\Exception $e) {
			$this->em->rollback();
			$form->addError($e->getMessage());
			$this->redrawControl('form');

			return false;
		}
		$this->redrawControl('form');
	}
	
	public function setCountry($id)
	{
		$this->country = $this->countriesService->get($id);
		
		if ($this->country) {
			$o = $this->country;
			$this['form']['id']->setDisabled(true);
			$this['form']->setDefaults([
				'name' => $o->getName(),
				'id'   => $o->getId(),
			]);
		} else
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}
}
