<?php declare(strict_types = 1);

namespace Core\AdminModule\Components\Country;

use Core\Model\UI\BaseControl;
use Core\Model\Countries;
use Core\Model\Entities\Country;


class CountryGrid extends BaseControl
{
	/** var Countries */
	protected $countriesService;
	
	public function __construct(Countries $countries)
	{
		$this->countriesService = $countries;
	}
	
	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}
	
	protected function createComponentGrid()
	{
		$grid = $this->createGrid();
		
		$qb = $this->countriesService->getEr()->createQueryBuilder('p')->orderBy('p.position', 'ASC');
		$grid->setDataSource($qb);
		
		$grid->setSortable();
		$grid->setSortableHandler('countryGrid:gridSortableRow!');
		
		//Columns
		$grid->addColumnText('id', 'default.id');
		$grid->addColumnLink('name', 'default.name', 'Country:editCountry');
		
		
		// Actions
		$grid->addAction('edit', '', 'Country:editCountry')->setIcon('edit')->setBsType('primary');
		$grid->addAction('delete', '', 'delete!')->setConfirm('default.reallyDelete')->setIcon('times')->setBsType('danger')->addClass('ajax');
		
		// Columns prototype
		
		return $grid;
	}
	

	/*******************************************************************************************************************
	 * ==================  Handle
	 */
	
	public function handleDelete($id)
	{
		$presenter = $this->getPresenter();
		if ($this->countriesService->remove($id))
			$presenter->flashMessageSuccess('default.removed');
		else
			$presenter->flashMessageDanger('default.removeFailed');
		
		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}
	

	/*******************************************************************************************************************
	 * =================  Grid function
	 */
	
	public function handleGridSortableRow()
	{
		$presenter = $this->getPresenter();
		$request   = $presenter->getHttpRequest();
		$id        = $request->getPost('id', null);
		$position  = $request->getPost('position', null);
		
		if ($id != null && $position != null && $this->countriesService->setPosition($id, $position)) {
			$presenter->flashMessageSuccess('default.positionChanged');
		} else {
			$presenter->flashMessageDanger('default.positionChangeFailed');
		}
		
		$presenter->redrawControl('flashes');
		$presenter->redrawControl('countryGrid');
	}
	
}
