<?php declare(strict_types = 1);

namespace Core\Model\FilesManager;

use Core\Model\Images\ImagePipe;

/**
 * Class ElFinderImage
 * @package Core\Model\FilesManager
 */
class ElFinderImage
{
	/** @var ImagePipe */
	protected $imagePipe;

	public function __construct(ImagePipe $imagePipe)
	{
		$this->imagePipe = $imagePipe;
	}

	/**
	 *
	 * @param  string                $cmd      command name
	 * @param  array                 $result   command result
	 * @param  array                 $args     command arguments from client
	 * @param  \elFinder             $elfinder elFinder instance
	 * @param  \elFinderVolumeDriver $volume   elFinder current volume instance
	 *
	 * @return void|true
	 * @author Dmitry (dio) Levashov
	 **/
	public function removeThumbs($cmd, $result, $args, $elfinder, $volume)
	{
		foreach ($result['removed'] as $removed) {
			$this->imagePipe->removeThumbs($removed['realpath']);
		}
	}
}