<?php declare(strict_types = 1);

namespace Core\AdminModule\Presenters;

use Nette\Application\Responses\FileResponse;

class FileResponsePresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
	}

	/*******************************************************************************************************************
	 * ===============================  Render
	 */

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault(string $data)
	{
		$data = unserialize(base64_decode($data));

		if ($data['file'] && file_exists($data['file'])) {
			$basename = $data['filename'] ?: basename($data['file']);
			$this->sendResponse(new FileResponse($data['file'], $basename));
		}

		exit;
	}
}
