<?php declare(strict_types = 1);

namespace Core\Components\FilesManager;

use Core\Model\FilesManager\FilesManager as FM;
use Core\Model\UI\BaseControl;
use Nette\Http\Request;
use Nette\Http\Session;
use Nette\Http\SessionSection;

class FilesManager extends BaseControl
{
	private static $assetsLoaded = false;

	/** @var FM */
	private $fm;

	/** @var SessionSection */
	protected $sessionSection;

	/** @var Request */
	protected $request;

	/** @var bool */
	private $isModal = false;

	/** @var bool @persistent */
	public $modalShowed = false;

	/** @var string @persistent */
	public $modalName;

	public function __construct(FM $fm, Session $session, Request $request)
	{
		$this->fm             = $fm;
		$this->request        = $request;
		$this->sessionSection = $session->getSection('filemanager');
	}

	public function render()
	{
		$this->template->assetsLoaded = self::$assetsLoaded;
		//		$this->template->modalName    = $this->modalName;
		$this->template->modalShowed    = $this->modalShowed;
		$this->template->isModal        = $this->isModal;
		$this->template->elFinderUrl    = $this->link('elFinder!');
		$this->template->closeModalLink = $this->link('closeModal!', [$this->name]);
		$this->template->render(__DIR__ . '/FilesManager.latte');
	}

	public function handleShowModal($modalName)
	{
		$roots = $this->request->getPost('roots');
		if ($roots) {
			foreach ($roots as $root) {
				if (is_string($root)) {
					$root = ltrim($root, '/');

					$this->sessionSection->roots[$modalName][$root] = [
						'driver'  => 'LocalFileSystem',
						'path'    => WWW_DIR . '/' . $root,
						'URL'     => '/' . $root,
						'tmbPath' => WWW_DIR . '/thumbs/' . $root,
						'tmbURL'  => '/thumbs/' . $root,
						'utf8fix' => true,
					];
				} else
					$this->sessionSection->roots = $root;
			}
		}
		$this->setModalName($modalName);
		$this->modalShowed = true;

		if ($this->getPresenter()->isAjax()) {
			$this->redrawControl('modal');
		} else {
			$this->redirect('this');
		}
	}

	public function handleCloseModal($modalName)
	{
		$this->sessionSection->roots[$modalName] = [];
	}

	public function handleElFinder()
	{
		$this->fm->run(['rootsSession' => $this->modalName]);
	}

	public function setModal($modal = true)
	{
		$this->isModal = $modal;
	}

	public function setModalName($name)
	{
		$this->modalName = $name;
	}

	public function addRoot($arr)
	{
		$this->fm->addRoot($arr);
	}
}
