<?php declare(strict_types = 1);

namespace Core\Model\Templating\Filters;

use Nette\Localization\ITranslator;
use function SimpleHtmlDom\str_get_html;

class EditorData
{
	/** @var ITranslator */
	protected $translator;

	public function __construct(ITranslator $translator)
	{
		$this->translator = $translator;
	}

	public function __invoke($string)
	{
		if (!$string)
			return $string;

		$html = str_get_html($string);

		$readMore = $html->find('.ck-readmore');

		$mText = $this->translator->translate('front.editor.readMore');
		$lText = $this->translator->translate('front.editor.readLess');
		foreach ($readMore as $k => $rm) {
			$prev   = $rm->prev_sibling();
			$method = $prev->tag != 'p' ? 'outertext' : 'innertext';

			$prev->$method .= ' <a href="#readMore' . $k . '" class="ck-readmore-trigger" data-more="' . $mText . '" data-less="' . $lText . '">' . $mText . '</a>';
			$rm->id        = 'readMore' . $k;
		}

		return (string) $html;
	}
}
