function btnConfirm(element, event) {
	let confirmText = element.dataset.confirm === '1' ? texts.btnConfirmText : element.dataset.confirm;
	if (!confirm(confirmText)) {
		if (event) {
			event.stopImmediatePropagation();
			event.preventDefault();
		}

		return false;
	}

	return true;
}

var sortables = [];

jQuery(function ($) {
	$(document).ready(function () {
		$(document).on('click', '[data-confirm]', function (e) {
			btnConfirm(this, e);
		});

		$.nette.init();
		$.nette.ext('unique', null);
		$.nette.ext('btnConfirm', {
			before: function (jqXHR, settings) {
				if (settings.nette && settings.nette.el[0].dataset.confirm !== undefined) {
					if (!btnConfirm(settings.nette.el[0])) {
						return false;
					}
				}
			}
		});
		$.nette.ext('loading-overlay', {
			before: function (jqXHR, settings) {
				let loadingOverlay = document.getElementById('loading-overlay');

				if (loadingOverlay !== null) {
					loadingOverlay.dataset.count = parseInt(loadingOverlay.dataset.count) + 1;
				} else {
					document.getElementsByTagName('BODY')[0].insertAdjacentHTML('beforeend', '<div id="loading-overlay" data-count="1">' +
						'<div class="spinner">' +
						'<div class="rect1"></div>' +
						'<div class="rect2"></div>' +
						'<div class="rect3"></div>' +
						'<div class="rect4"></div>' +
						'<div class="rect5"></div>' +
						'</div></div>');
				}
			},
			complete: function () {
				let loadingOverlay = document.getElementById('loading-overlay');

				if (loadingOverlay) {
					if (loadingOverlay.dataset.count > 1)
						loadingOverlay.dataset.count = parseInt(loadingOverlay.dataset.count) - 1;
					else
						loadingOverlay.parentNode.removeChild(loadingOverlay);
				}
			}
		});
		$.nette.ext('bs-modal', {
			init: function () {
				// if the modal has some content, show it when page is loaded
				var $modal = $('.modal');
				if ($modal.find('.modal-content').html().trim().length !== 0) {
					$modal.modal('show');
					// setModalMaxHeight($modal);
				}
			},
			success: function (jqXHR, status, settings) {
				var snippetName = null,
					$snippet = null;
				if (settings.responseJSON) {
					if (typeof settings.responseJSON.snippets != 'undefined') {
						$.each(settings.responseJSON.snippets, function (name, content) {
							if (name.match("^snippet-") && name.match("-modal$")) {
								snippetName = name;
								$snippet = content;
							}
						});
					}

					var $modal = $('#' + snippetName).parents('.modal');

					$modal.each(function (i, m) {
						var $m = $(m);

						if ($m.parents('.modal').length) {
							$m.detach();
							$('body').append($m);
						}
					});

					if (settings.responseJSON.hideModal === true) {
						if (!$modal.length)
							$modal = $('.modal.show');

						$modal = $($modal[$modal.length - 1]);
						$modal.modal('hide');
					} else {
						if (!$snippet)
							return;

						var $modalBody = $modal.find('.modal-body').first(),
							$modalFooter = $modalBody.next('.modal-footer');
						if ($modal && $modalBody.length && $modalBody.html().trim().length !== 0) {
							var $form = $modalBody.find('form');

							// if ($form.length == 1 && $modalFooter.length) {
							// 	var $formSubmit = $form.find('[type="submit"]').parent('.btn-group');
							//
							// 	if ($formSubmit.length) {
							// 		$formSubmit.detach();
							// 		$modalFooter.append($formSubmit);
							// 	}
							// }
							//
							$modal.modal('show');
							// setModalMaxHeight($modal);
						} else {
							$modal = $($modal[$modal.length - 1]);
							$modal.modal('hide');
						}
					}
				}
			}
		});

		$(document).on('show.bs.modal', function (e) {
			var $modal = $(e.target),
				ghostId = 'm_' + Math.random().toString(36).substring(7);

			if ($modal.hasClass('modal') && !$modal.hasClass('show')) {
				$modal.attr('data-ghost-id', ghostId);
				$modal.parent('').attr('data-modal-ghost', ghostId);

				$('body').append($modal.detach());
			}
		});

		$(document).on('hidden.bs.modal', function (e) {
			var $modal = $(e.target),
				$ghostWrap = $('[data-modal-ghost="' + $modal.attr('data-ghost-id') + '"]');

			if ($modal.hasClass('modal')) {
				$ghostWrap.append($modal.detach());

				if ($('.modal.show').length) {
					$('body').addClass('modal-open');
				}
			}
		});

		$('[data-toggle="tooltip"]').tooltip();

		$(document).ajaxComplete(function (event, xhr, settings) {
			$('[data-toggle="tooltip"]').tooltip('dispose');
			$('[data-toggle="tooltip"]').tooltip();

			try {
				window.fileRequest(xhr.responseJSON.fileRequests);
			} catch (e) {

			}
		});

		/**
		 * Sliding v postranim menu
		 */
		$('.sidebar .parent > div').click(function (e) {
			var submenu = $(this).parents('.parent').find('ul');
			$(this).find('.arrow').toggleClass('opened');
			if (submenu.is(':visible'))
				submenu.slideUp();
			else
				submenu.slideDown();
		});

		/**
		 * Loader when click on the primary button
		 */
		/*
		 $('.btn-primary').click(function () {
		 console.log($(this).find('svg').length == 0);
		 if ($(this).find('svg').length == 0) {
		 $(this).html('<img class="loader" src="/assets/admin/img/loading.svg">')
		 }
		 })*/

		initSort();
		initSwitchContentLang();
		$(document).ajaxComplete(function (event, xhr, settings) {
			initSwitchContentLang();

			let data = xhr.responseJSON;
			if (data) {
				if (data.treeViewItemDeleted === true)
					$(event.target.activeElement).parents('.datagrid-tree-item').first().slideUp();

				if (data.datagridTreeItemAppend !== undefined) {
					let itemData = data.datagridTreeItemAppend,
						snippetDataName = 'snippet-' + itemData.grid + '-item-' + itemData.id,
						$html = $(data.snippets[snippetDataName]);

					let $table = $('#snippet-' + itemData.grid + '-table');
					let $tmp = $('<div data-id="' + itemData.id + '" class="datagrid-tree-item" id="' + snippetDataName + '"></div>');
					$tmp.append($html);
					$html = $tmp;
					$html.hide();
					if (itemData.dataId) {
						$table.find('.datagrid-tree-item[data-id="' + itemData.dataId + '"]').find('.datagrid-tree-item-children').children('.datagrid-tree-item').last().after($html);
					} else {
						$table.children('.datagrid-tree-item').last().after($html);
					}
					$html.slideDown();
				}
			}

			initSort();
		});
	});
});

function initSort() {
	$('.sortable-checkbox-list').each(function (i, v) {
		Sortable.create(v);

		$(v).find('.item').each(function () {
			var $item = $(this);
			$item.find('input').on('change', function () {
				$item.attr('data-active', $(this).is(':checked') ? '1' : '0');
			});
		})
	});

	// Sortable ublaboo datagrid
	$('tbody[data-sortable]').each(function () {
		var $tbody = $(this),
			sortUrl = $tbody.attr('data-sortable-url'),
			dataGroup, dataGroupTree, attrVal, attrName, groupAttr, trSelector;

		if (this.dataset.sortableId !== undefined && sortables[this.dataset.sortableId] !== undefined) {
			sortables[this.dataset.sortableId].destroy();
			sortables[this.dataset.sortableId] = undefined;
		}
		let sortable = Sortable.create(this, {
			animation: 150,
			handle: '.handle-sort',
			filter: '.ignore-sort',
			draggable: 'tr',
			onChoose: function (e) {
				var $item = $(e.item),
					dataGroup = $item.attr('data-group'),
					dataGroupTree = $item.attr('data-group-tree');

				if (dataGroup) {
					$item.siblings('[data-group!="' + dataGroup + '"]').addClass('ignore-sort');//.slideUp();
				} else if (dataGroupTree) {
					$item.siblings('[data-group-tree!="' + dataGroupTree + '"]').addClass('ignore-sort');//.slideUp();
					$item.attr('data-old-index', Sortable.utils.index(e.item, 'tr.group_' + dataGroupTree));
				}

				dataGroup = e.item.getAttribute('data-group');
				dataGroupTree = e.item.getAttribute('data-group-tree');
				groupAttr = e.item.getAttribute(attrName);

				if (dataGroup) {
					attrVal = dataGroup;
					attrName = 'data-group';
				} else if (dataGroupTree) {
					attrVal = dataGroupTree;
					attrName = 'data-group-tree';
				}

				trSelector = 'tr.group_' + attrVal;
			},
			onEnd: function (e) {
				var $item = $(e.item),
					newIndex = $item.attr('data-new-index'),
					oldIndex = $item.attr('data-old-index');

				if ($item.attr('data-group-tree')) {
					var group = $item.attr('data-group-tree'),
						$prev = $item.prev(),
						$next = $item.next(),
						data = {
							id: $item.attr('data-id'),
							type: 'tree',
							position: newIndex,
							move: newIndex - oldIndex,
						};

					if (group == $prev.attr('data-group-tree'))
						data.prev = $prev.attr('data-id');
					if (group == $next.attr('data-group-tree'))
						data.next = $next.attr('data-id');
				} else {
					if ($item.attr('data-position') !== undefined)
						var tmp = parseInt($item.attr('data-position')) - (e.oldIndex - e.newIndex);
					else
						var tmp = newIndex;
					var data = {
						id: $item.attr('data-id'),
						position: tmp,
						type: 'default',
					};
				}

				$item.siblings().removeClass('ignore-sort');//.slideDown();
				$.nette.ajax({
					url: sortUrl,
					method: 'post',
					data: data,
					success: function (response) {
					},
				})

				dataGroup = undefined;
				dataGroupTree = undefined;
				attrVal = undefined;
				attrName = undefined;
				groupAttr = undefined;
				trSelector = undefined;
			},
			onMove: function (e) {
				// var dataGroup = e.dragged.getAttribute('data-group'),
				// 	dataGroupTree = e.dragged.getAttribute('data-group-tree');
				//
				// var attrVal = '',
				// 	attrName = '';
				// if (dataGroup) {
				// 	attrVal = dataGroup;
				// 	attrName = 'data-group';
				// } else if (dataGroupTree) {
				// 	attrVal = dataGroupTree;
				// 	attrName = 'data-group-tree';
				// }
				//
				// var trSelector = 'tr.group_' + attrVal;
				//
				// $(e.dragged).attr('data-new-index', Sortable.utils.index(e.related, trSelector));
				// return attrVal ? e.related.className.indexOf('group_' + e.dragged.getAttribute(attrName)) !== -1 : true;

				$(e.dragged).attr('data-new-index', Sortable.utils.index(e.related, trSelector));
				return attrVal ? e.related.className.indexOf('group_' + attrVal) !== -1 : true;
			},
		});
		this.dataset.sortableId = 's_' + Math.random().toString(36).substring(7);
		sortables[this.dataset.sortableId] = sortable;
	});

	// Sortable tree
	$('.datagrid-tree[data-sortable-tree], .datagrid-tree-item-children.loaded').each(function () {
		var $body = $(this),
			sortUrl = $body.attr('data-sortable-url'),
			selectedId;

		if (this.dataset.sortableId !== undefined && sortables[this.dataset.sortableId] !== undefined) {
			sortables[this.dataset.sortableId].destroy();
			sortables[this.dataset.sortableId] = undefined;
		}

		let sortable = Sortable.create(this, {
			animation: 150,
			handle: '.handle-sort',
			filter: '.ignore-sort',
			draggable: '> .datagrid-tree-item',
			onChoose: function (e) {
				var $item = $(e.item),
					$chevron = $item.children().first().find('.datagrid-tree-item-left .chevron');

				if ($chevron.length && $chevron.hasClass('toggle-rotate')) {
					$chevron.trigger('click');
				}

				$item.attr('data-old-pos', $item.index());
				selectedId = $item.children()[0].dataset.id;
			},
			onEnd: function (e) {
				var $item = $(e.item),
					oldIndex = e.item.dataset.oldPos,
					newIndex = $item.index();
				$.nette.ajax({
					url: sortUrl,
					method: 'post',
					data: {
						id: selectedId,
						move: (oldIndex - newIndex),
					},
					complete: function () {
						selectedId = undefined;
					}
				});
			}
		});
		this.dataset.sortableId = 's_' + Math.random().toString(36).substring(7);
		sortables[this.dataset.sortableId] = sortable;
	});
}

function number_format(number, decimals, dec_point, thousands_sep) {
	// Strip all characters but numerical ones.
	number = (number + '').replace(/[^0-9+\-Ee.]/g, '');
	var n = !isFinite(+number) ? 0 : +number,
		prec = !isFinite(+decimals) ? 0 : Math.abs(decimals),
		sep = (typeof thousands_sep === 'undefined') ? ',' : thousands_sep,
		dec = (typeof dec_point === 'undefined') ? '.' : dec_point,
		s = '',
		toFixedFix = function (n, prec) {
			var k = Math.pow(10, prec);
			return '' + Math.round(n * k) / k;
		};
	// Fix for IE parseFloat(0.55).toFixed(0) = 0;
	s = (prec ? toFixedFix(n, prec) : '' + Math.round(n)).split('.');
	if (s[0].length > 3) {
		s[0] = s[0].replace(/\B(?=(?:\d{3})+(?!\d))/g, sep);
	}
	if ((s[1] || '').length < prec) {
		s[1] = s[1] || '';
		s[1] += new Array(prec - s[1].length + 1).join('0');
	}
	return s.join(dec);
}

function initSwitchContentLang() {
	if ($('.content-lang-switcher').length) {
		var lang = $('[name="selectedContentLang"]:checked').val();
		if (lang === undefined) {
			lang = $('html').attr('lang');

			$('.content-lang-switcher input[value="' + lang + '"]').trigger('click');
		} else {
			switchContentLang(lang);

			if (typeof (CKEDITOR) !== "undefined") {
				CKEDITOR.on('instanceReady', function () {
					switchContentLang(lang);
				});
			}
		}
	}
}

function switchContentLang(lang) {
	Cookies.set('contentLang', lang);
	$('[data-content-lang]').each(function () {
		var $this = $(this),
			isEditor = $this.next().hasClass('cke');
		if (this.dataset.contentLang != lang) {
			if (isEditor) {
				$this.next().hide();
			} else {
				$this.hide();
			}
		} else {
			if (isEditor) {
				$this.next().show();
			} else {
				$this.show();
			}
		}
	});
}

function showPicture(id, source) {
	if (source == "1") {
		if (document.layers) document.layers['' + id + ''].visibility = "show"
		else if (document.all) document.all['' + id + ''].style.visibility = "visible"
		else if (document.getElementById) document.getElementById('' + id + '').style.visibility = "visible"
	} else if (source == "0") {
		if (document.layers) document.layers['' + id + ''].visibility = "hide"
		else if (document.all) document.all['' + id + ''].style.visibility = "hidden"
		else if (document.getElementById) document.getElementById('' + id + '').style.visibility = "hidden"
	}
}
