<?php declare(strict_types = 1);

namespace Core\Components\Header;

use Core\FrontModule\Model\SeoParser;
use Core\Model\UI\BaseControl;
use Nette\Utils\Html;

/**
 * Class Title
 * @package Core\Components\Header
 */
class Title extends BaseControl
{
	/** @var string */
	private $title;

	/** @var string */
	private $colonText;

	/** @var string */
	protected $siteName;

	/** @var string */
	protected $siteNameSeparator;

	/** @var bool */
	protected $includeSiteName = true;

	/** @var SeoParser */
	protected $seoParserService;

	public function __construct(string $siteName, string $siteNameSeparator, SeoParser $seoParser)
	{
		$this->siteName          = $siteName;
		$this->siteNameSeparator = $siteNameSeparator;
		$this->seoParserService  = $seoParser;
	}

	public function render()
	{
		$this->template->title = trim(strip_tags($this->getFullTitle()));

		$this->template->setFile(__DIR__ . '/Title.latte');
		$this->template->render();
	}

	/*******************************************************************************************************************
	 * ======================== Setters
	 */

	/**
	 * @param string $title
	 * @param bool   $includeSiteName
	 */
	public function setTitle($title, $includeSiteName = true)
	{
		$this->title           = $title;
		$this->includeSiteName = $includeSiteName;
	}

	/**
	 * @param string $text
	 */
	public function setColonText($text)
	{
		if ($text)
			$this->colonText = Html::el('span class=font-weight-light')->setText($text);
	}

	/*******************************************************************************************************************
	 * ======================== Getters
	 */

	/**
	 * @return string
	 */
	public function getTitle(): string { return $this->seoParserService->parse(trim("$this->title $this->colonText")); }

	/**
	 * @return string
	 */
	public function getFullTitle(): string
	{
		if ($this->includeSiteName)
			$title = $this->title;
		else
			$title = trim($this->title ? $this->title . ($this->colonText ? ': ' . $this->colonText : '') . " $this->siteNameSeparator $this->siteName" : $this->siteName);

		return $this->seoParserService->parse((string) $title);
	}
}
