<?php declare(strict_types = 1);

namespace Core\Model\Helpers\Traits;

use Kdyby\Doctrine\EntityManager;
use Kdyby\Doctrine\EntityRepository;

/**
 * Trait TPosition
 * @package Core\Model\Helpers\Traits
 *
 * @property EntityManager $em
 * @method EntityRepository getEr()
 */
trait TPosition
{
	/**
	 * @param int $id
	 * @param int $position
	 *
	 * @return bool
	 * @throws \Exception
	 */
	public function setPosition($id, $position)
	{
		if ($item = $this->getReference($id)) {
			$item->setPosition((int) $position);
			$this->em->persist($item);
			$this->em->flush();

			return true;
		}

		return false;
	}

	/**
	 * @return bool
	 * @throws \Doctrine\DBAL\DBALException
	 */
	public function repairPositions()
	{
		$items = $this->getEr()->createQueryBuilder('e')->select('e.id, e.position')
			->orderBy('e.position')->addOrderBy('e.id')->getQuery()->getArrayResult();

		$i = 0;
		foreach ($items as $item) {
			$this->em->getConnection()
				->prepare('UPDATE ' . $this->getEr()->getClassMetadata()->getTableName() . ' SET position = :position WHERE id = :id')
				->execute(['position' => $i, 'id' => $item['id']]);
			$i++;
		}

		return true;
	}
}
