<?php declare(strict_types = 1);

namespace Core\Model\Router;

use Core\Model\Lang\DefaultLang;
use Core\Model\Lang\Langs;
use Nette\Localization\ITranslator;

/**
 * Class RouteHelper
 * @package Core\Model\Router
 */
class RouteHelper
{
	/** @var DefaultLang */
	protected $defaultLang;

	/** @var Langs */
	protected $langsService;

	public function __construct(DefaultLang $defaultLang, Langs $langs)
	{
		$this->defaultLang  = $defaultLang;
		$this->langsService = $langs;
	}

	public function createRoute($mask, $metadata = [], $flags = 0, $locale = null)
	{
		if (!$locale || !array_key_exists($locale, $this->langsService->getLangs(false))) {
			$locale = $this->defaultLang->default;
		}

		return new Route($mask, $metadata, $flags, $locale);
	}

	public function createAdminRoute($mask, $metadata = [], $flags = 0, $locale = null)
	{
		if (!$locale || !array_key_exists($locale, $this->langsService->getLangs(false))) {
			$locale = $this->defaultLang->default;
		}

		return new RouteAdmin($mask, $metadata, $flags, $locale);
	}
}
