import $ from 'jquery';

export const scrollTo = (amount, speed = 1000) => {
	const body = $("html, body");
	body.stop().animate({scrollTop: amount}, 1000, 'swing', function () {
	});
};

export function responsive(func) {
	func();
	$(window).on('resize', function () {
		func();
	})
}

export function checkMedia(mediaWith, maxmin = "max") {
	return window.matchMedia('(' + maxmin + '-width: ' + mediaWith + 'px)').matches;
}

export function responsiveOnMedia(onMediaEnter, onMediaExit, mediaWith, maxmin = "max") {
	if (checkMedia(mediaWith, maxmin)) onMediaEnter();
	$(window).on('resize', function () {
		if (checkMedia(mediaWith, maxmin)) onMediaEnter();
		else onMediaExit();
	})
}

export function convertRemToPixels(rem) {
	return rem * parseFloat(getComputedStyle(document.documentElement).fontSize);
}

export function arrayRemove(arr, value) {
	return arr.filter((el) => {
		return el != value;
	});
}
