<?php declare(strict_types = 1);

namespace Core\AdminModule\Presenters;

use Core\AdminModule\Components\Country\ICountryGridFactory;
use Core\AdminModule\Components\Country\ICountryFormFactory;
use Core\Model\Entities\Country;
use Core\Model\UI\Form\BaseForm;

class CountryPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'settings'))
			$this->error();

		$this->setHeader('admin.title.country', 'fas fa-flag');
	}

	/*******************************************************************************************************************
	 * ===============================  Render
	 */
	
	/*******************************************************************************************************************
	 * ============================== Actions
	 */
	
	public function actionDefault()
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'admin.menu.countryAdd',
				'link'  => 'Country:addCountry',
				'ico'   => 'plus',
			]
		]]);
	}
	
	public function actionAddCountry()
	{
		$this->setTitle($this->translator->translate('admin.menu.countryAdd'));
		$this->setHeader('admin.menu.countryAdd','fa fa-flag');
	}
	
	public function actionEditCountry($id)
	{
		$country = $this->em->getRepository(Country::class)->find($id);
		
		if (!$country)
			$this->error(null, IResponse::S404_NOT_FOUND);
		
		$this->setTitle($this->translator->translate('admin.title.countryEdit'), $country->name);
		$this->setHeader('admin.title.countryEdit', 'fa fa-flag');
	}

	/*******************************************************************************************************************
	 * ===============================  Components
	 */
	
	protected function createComponentCountryGrid(ICountryGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentCountryForm(ICountryFormFactory $factory)
	{
		$control = $factory->create();
		
		if ($this->getParameter('id'))
			$control->setCountry($this->getParameter('id'));
		
		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('editCountry', $form->getCustomData('countryId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function(BaseForm $form) {
			$this->redirect('default');
		};
		$control['form']->onCancel[]              = function(BaseForm $form) {
			$this->redirect('default');
		};
		
		return $control;
	}
}
