<?php declare(strict_types = 1);

namespace Core\Model\Helpers;

use Doctrine\ORM\EntityRepository;
use Kdyby\Doctrine\EntityManager;
use Nette\Localization\ITranslator;

abstract class BaseFrontEntityService extends BaseService
{
	/** @var EntityManager @inject */
	public $em;

	/** @var ITranslator @inject */
	public $translator;

	/** @var EntityRepository */
	protected $er;

	/** @var \stdClass */
	protected $entityClass;

	public function getEr()
	{
		if ($this->er === null)
			$this->er = $this->em->getRepository($this->entityClass);

		return $this->er;
	}
}
