<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Core\Model\UI\Form\Traits\BootstrapButtonTrait;
use Core\Model\UI\Form\Traits\TInputExtend;
use Nette\Forms\Controls\Button;
use Nette\Utils\Html;


/**
 * Class ButtonInput.
 * Returns &lt;button&gt; whose content can be set as caption.
 * @package Czubehead\BootstrapForms
 * @property string $btnClass
 */
class ButtonInput extends Button
{
	use BootstrapButtonTrait;
	use TInputExtend;

	/**
	 * ButtonInput constructor.
	 *
	 * @param null|string|Html $content
	 */
	public function __construct($content = null)
	{
		parent::__construct($content);
	}

	/**
	 * @param null|string|Html $content
	 *
	 * @return Html
	 */
	public function getControl($content = null)
	{
		$btn = Html::el('button', [
			'type' => 'button',
		]);
		$btn->setHtml($content === null ? $this->caption : $content);
		$this->addBtnClass($btn);

		return $btn;
	}
}
