<?php declare(strict_types = 1);

namespace Core\FrontModule\Model;

class Search
{
	/** @var SearchItemsCollection */
	protected $searchItemsCollection;

	public function __construct(SearchItemsCollection $searchItemsCollection)
	{
		$this->searchItemsCollection = $searchItemsCollection;
	}

	public function search(string $q)
	{
		$result = [];

		foreach ($this->searchItemsCollection->getItems() as $k => $item) {
			foreach ($item->search($q) as $item) {
				$result[$item->group][] = $item;
			}
		}

		return $result;
	}
}
