<?php declare(strict_types = 1);

namespace Core\FrontModule\Model;

class SeoParser
{
	/** @var string */
	protected $siteName;

	/** @var string */
	protected $separator;

	public function __construct($siteName, $separator)
	{
		$this->siteName  = $siteName;
		$this->separator = $separator;
	}

	/**
	 * @param string $string
	 *
	 * @return string
	 */
	public function parse(string $string): string
	{
		$string = str_replace(['$siteName', '$separator'], [$this->siteName, $this->separator], $string);
		$string = trim($string);

		return $string;
	}
}
