<?php declare(strict_types = 1);

namespace Core\Model\UI;

trait TUITemplate
{
	public function formatTemplateFiles()
	{
		$list = [];

		$path = explode(':', $this->getName());

		if (count($path) > 2) {
			$tmp     = $path[1];
			$path[1] = $path[0];
			$path[0] = $tmp;
		}

		if ($path[0] == 'Error')
			unset($path[1]);

		//TODO možnost měnit šablonu
		$module = array_shift($path);
		$list[] = TEMPLATES_DIR . '/' . $module . '/default/' . implode('/', $path) . '/' . $this->view . '.latte';
		$list[] = dirname($this->getReflection()->getFileName()) . '/../Templates/' . ucfirst(end($path)) . '/' . $this->view . '.latte';
		$list[] = dirname($this->getReflection()->getParentClass()->getFileName()) . '/../Templates/' . ucfirst(end($path)) . '/' . $this->view . '.latte';

		return $list;
	}

	public function formatLayoutTemplateFiles()
	{
		if ($this->layout)
			return [$this->layout];

		$list = [];

		$path = explode(':', $this->getName());

		if (count($path) > 2) {
			$tmp     = $path[1];
			$path[1] = $path[0];
			$path[0] = $tmp;
		}

		$module = array_shift($path);
		$action = end($path);

		//TODO možnost měnit šablonu
		do {
			$list[] = TEMPLATES_DIR . '/' . $module . '/default' . ($path ? '/' . implode('/', $path) : '') . '/@layout.latte';
		} while (array_pop($path));

		$list[] = dirname($this->getReflection()->getFileName()) . '/../Templates/' . $action . '/@layout.latte';
		$list[] = dirname($this->getReflection()->getFileName()) . '/../Templates/@layout.latte';
		$list[] = SRC_DIR . '/core/src/AdminModule/Templates/@layout.latte';

		return $list;
	}
}
