import {Autocomplete}     from './components/autocomplete';
import {addEventForChild} from './utils/utilities';
import SimpleBar          from "simplebar";

const loadSvgIcons = () => {
	document.querySelectorAll('[data-svg-icon]').forEach(el => {
		let XMLrequest = new XMLHttpRequest();
		XMLrequest.open("GET", '/assets/front/img/icons/' + el.dataset.svgIcon + '.svg', true); // URL of the SVG file on server
		XMLrequest.send(null);
		el.removeAttribute('data-svg-icon');
		XMLrequest.onload = function (e) {
			el.removeAttribute('data-svg-icon');
			if (el.dataset.replace !== undefined)
				el.outerHTML = XMLrequest.responseText;
			else
				el.insertAdjacentHTML('afterbegin', XMLrequest.responseText);
		}
	});
	document.querySelectorAll('[data-svg-img]').forEach(el => {
		let XMLrequest = new XMLHttpRequest();
		XMLrequest.open("GET", el.dataset.svgImg, true); // URL of the SVG file on server
		XMLrequest.send(null);
		el.removeAttribute('data-svg-icon');
		XMLrequest.onload = function (e) {
			el.removeAttribute('data-svg-img');
			if (el.dataset.replace !== undefined)
				el.outerHTML = XMLrequest.responseText;
			else
				el.insertAdjacentHTML('afterbegin', XMLrequest.responseText);
		}
	});
}

loadSvgIcons();

global.naja.addEventListener('start', e => {
	global.lastClicked = document.activeElement;
});

global.naja.addEventListener('complete', e => {
	loadSvgIcons();
	// Automatická změna titulku pokud proběhne ajax a je potřeba ho změnit
	if (e.response.pageTitle)
		document.title = e.response.pageTitle;

	// Aktualizace html elementu podle response
	if (e.response.ajaxPlaceholders) {
		for (let [key, value] of Object.entries(e.response.ajaxPlaceholders)) {
			document.querySelectorAll('[data-ajax-placeholder="' + key + '"').forEach(el => {
				el.innerHTML = value;
			})
		}
	}

	document.querySelectorAll('[data-simplebar]').forEach(el => {
		new SimpleBar(el);
	});
});

document.addEventListener('DOMContentLoaded', () => {
	new Autocomplete();

	/**
	 * Logika modalnich oken
	 */
	const darker = document.querySelector('.darker');
	const body   = document.querySelector('body');

	if (darker) {
		addEventForChild(body, 'click', '[data-modal]', el => {
			const modalTarget = el.dataset.modal;
			if (modalTarget) {
				document.querySelectorAll(modalTarget).forEach(el => el.classList.add('modal--active'));
			}
			darker.classList.add('darker--active');
		});

		darker.addEventListener('click', () => {
			document.querySelectorAll('.modal').forEach(el => {
				el.classList.remove('modal--active');
				darker.classList.remove('darker--active');
			});
		});

		addEventForChild(body, 'click', '.modal__close, [data-modal-close]', el => {
			document.querySelectorAll('.modal').forEach(el => el.classList.remove('modal--active'));
			darker.classList.remove('darker--active');
		});
	}
});

if (document.readyState === "complete") {
	new Autocomplete();
}
