import PhotoSwipe           from "photoswipe";
import PhotoSwipeUI_Default from "photoswipe/dist/photoswipe-ui-default";

export default class PhotoSwipeInitializator {
	static init(options) {
		options.history   = options.history || false;
		options.selector  = options.selector || document.querySelectorAll('.pswp')[0];
		const pswpElement = options.selector;
		document.querySelectorAll('[data-photoswipe]').forEach((el) => {
			el.addEventListener('click', (e) => {
				e.preventDefault();
				this.slides      = [];
				this.addedImages = [];
				this.slides.push(this.slideFactory(el));
				this.addedImages.push(el.dataset.imageId);
				const groupId = el.dataset.photoswipe;

				if (groupId) {
					const otherSlidesInGroup = document.querySelectorAll(`[data-photoswipe="${groupId}"]`);
					otherSlidesInGroup.forEach(el => {
						if (!this.addedImages.includes(el.dataset.imageId)) {
							this.slides.push(this.slideFactory(el))
							this.addedImages.push(el.dataset.imageId);
						}
					});
				}

				// Manually setting image size
				// https://github.com/dimsemenov/PhotoSwipe/issues/796
				const gallery = new PhotoSwipe(pswpElement, PhotoSwipeUI_Default, this.slides, options);
				gallery.listen('gettingData', (index, item) => {
					if (item.w < 1 || item.h < 1) {
						const img  = new Image();
						img.onload = function () {
							item.w = this.width;
							item.h = this.height;
							gallery.invalidateCurrItems();
							gallery.updateSize(true);
						};
						img.src    = item.src;
					}
				});

				gallery.init();

				gallery.listen('afterChange', () => {
					console.log('after change');
					this.removeVideo();
					this.detectVideo(gallery);
				});

				gallery.listen('beforeChange', () => {
					console.log('before change');
					this.removeVideo();
				});

				gallery.listen('close', () => {
					this.removeVideo();
				});
			})
		});
	}

	static removeVideo() {
		let videoHolder = document.querySelector('.pswp__video-holder');
		if (videoHolder) {
			videoHolder.remove();
		}
	}

	static detectVideo(gallery) {
		let item = gallery.currItem;
		if (item.youtubeId) {
			item.src = '';

			let wrapper = document.querySelector('.pswp__video-holder');
			if (!wrapper)
				wrapper = document.createElement('div');
			wrapper.classList.add('pswp__video-holder');
			wrapper.innerHTML =
				'<div class="inner-holder"><iframe src="http://www.youtube.com/embed/' + item.youtubeId + '?autoplay=1&autohide=1&controls=2&rel=0" frameborder="0" allowfullscreen="true"></iframe></div>';

			let parent = document.querySelector('.pswp__scroll-wrap');
			parent.appendChild(wrapper);
		}
	}

	static initGallery() {

	}

	static slideFactory(element) {
		let src = false;
		src     = element.attributes.href ? element.href : src;
		src     = element.dataset.href ? element.dataset.href : src;
		if (!src) throw Error("initialized data-photoswipe element does not have href attribute");

		let result = {
			src,
			w    : 0,
			h    : 0,
			msrc : src,
			title: '',
		};

		if (element.dataset.imageTitle)
			result.title += '<b>' + element.dataset.imageTitle + '</b>';
		if (element.dataset.imageDescription)
			result.title += '<p>' + element.dataset.imageDescription + '</p>';

		let link = element.dataset.imageLink;
		if (link) {
			let videoId = link.match(/(?:youtu\.be\/|youtube\.com(?:\/embed\/|\/v\/|\/watch\?v=|\/user\/\S+|\/ytscreeningroom\?v=))([\w\-]{10,12})\b/)[1];

			if (videoId) {
				result.youtubeId = videoId;
				result.src       = '';
			}
		}
//<iframe src="http://www.youtube.com/embed/' + videoId + '?autoplay=1&autohide=1&controls=2&rel=0" frameborder="0" allowfullscreen="true"></iframe>
		return result;
	}
}
