<?php declare(strict_types = 1);

namespace Core\Components\Navigation;

use Core\Model\Providers\ISiteMapUrl;
use Navigations\Model\Entities\Navigation;
use Nette\SmartObject;

class DaoNavigationItem implements ISiteMapUrl
{
	use SmartObject;

	/** @var int */
	public $id;

	/** @var string */
	public $title;

	/** @var string */
	public $alias;

	/** @var bool */
	public $isHomepage = false;

	/** @var string */
	public $lang;

	/** @var array */
	public $seo;

	/** @var int */
	public $lvl;

	/** @var string|array */
	public $link;

	/** @var string|null */
	public ?string $ico = null;

	/** @var string */
	public $icoClass;

	/** @var string */
	public $img;

	/** @var string */
	public $description;

	/** @var bool */
	public $isParent = false;

	/** @var string */
	public $class = '';

	/** @var bool */
	public $isCurrent = false;

	/** @var array */
	public $childs = [];

	/** @var DaoNavigationItem */
	public $parent;

	/** @var int */
	public $parentId;

	/** @var int */
	public $order = 100;

	/** @var string */
	public $openIn;

	/** @var string|null */
	public ?string $customText1 = null;

	/** @var string|null */
	public ?string $customText2 = null;

	/** @var DateTime */
	protected $modified;

	public    $security        = null;
	public    $componentType;
	public    $componentParams = [];
	protected $params          = [];
	public    $confirm;
	public    $groupType;

	public function __construct($arr = [], $parent = null)
	{
		$parameters = get_class_vars(self::class);

		if (is_object($arr)) {
			$tmp = (array) $arr;
			if ($arr instanceof Navigation) {
				foreach ($arr->getParams() as $k => $v) {
					$tmp[$k] = $v;
				}
			}

			$arr = $tmp;
		}

		foreach ($arr as $key => $value) {
			if ($key === 'ico') {
				$expl  = explode(' ', $value);
				$value = count($expl) === 1 ? 'fa fa-' . $value : $value;
			}

			if (array_key_exists($key, $parameters))
				$this->$key = $value;
			elseif ($key === 'items') {
				$this->isParent = true;
				foreach ($value as $deepK => $deepV)
					$this->childs[$deepK] = new DaoNavigationItem($deepV, $this);
			}
		}

		$this->parent = &$parent;
	}

	public function getId(): ?int { return $this->id; }

	public function set($key, $value)
	{
		$this->$key = $value;
	}

	/**
	 * @return bool
	 */
	public function isChildrenCurrent()
	{
		foreach ($this->childs as $item) {
			if ($item->isCurrent)
				return true;
		}

		return false;
	}

	/**
	 * @param DaoNavigationItem $dao
	 *
	 * @return $this
	 */
	public function addChild(DaoNavigationItem $dao)
	{
		$this->childs[] = $dao;

		return $this;
	}

	public function setParams(array $arr): self
	{
		$this->params = $arr;

		return $this;
	}

	public function setParam(string $key, $value): self
	{
		$this->params[$key] = $value;

		return $this;
	}

	public function getParam(string $key) { return $this->params[$key] ?? null; }

	public function getLang(): ?string { return $this->lang; }

	/**
	 * @param string|array $key
	 * @param mixed        $value
	 *
	 * @return DaoNavigationItem
	 */
	public function setSeo($key, $value = null): self
	{
		if (is_array($key))
			$this->seo = $key;
		else
			$this->seo[$key] = $value;

		return $this;
	}

	public function getSeo(?string $v = null)
	{
		if ($v)
			return $this->seo[$v] ?? null;

		return $this->seo ?: [];
	}

	public function setModified(\DateTime $dateTime): self
	{
		$this->modified = $dateTime;

		return $this;
	}

	public function getModified() { $this->modified; }

	public function getImages() { return []; }
}
