<?php declare(strict_types = 1);

namespace Core\ErrorModule\Presenters;

use Core\Components\Navigation\INavigationFactory;
use Core\ErrorModule\Presenters\CustomBasePresenter;
use Core\Model\Lang\Langs;
use Navigations\Model\Navigations;
use Nette\ComponentModel\IComponent;

abstract class BasePresenter extends CustomBasePresenter
{
	/** @var Navigations @inject */
	public $navigationsService;

	/** @var Langs @inject */
	public $langsService;

	protected function startup()
	{
		parent::startup();
		$this['meta']->setMeta('robots', 'noindex,nofollow');
		$this['title']->setTitle($this->translator->translate('default.errorPage.title'));

		$tmp = explode('/', $this->getHttpRequest()->getUrl()->getPath());

		if ($tmp[1] && array_key_exists($tmp[1], $this->langsService->getLangs(false))) {
			$this->langsService->setDefault($tmp[1]);
			$this->translator->setLocale($tmp[1]);
			$this->locale = $tmp[1];
		}
	}

	protected function createComponentNavigation(INavigationFactory $factory)
	{
		$control = $factory->create();
		$control->setData($this->navigationsService->getPublishedDaoNavigationStructure());

		return $control;
	}

	public function getActiveNavigation()
	{
		return $this->navigationsService->getHomepage();
	}

	/*******************************************************************************************************************
	 * =============================== Handle
	 */

	public function handleLogout()
	{
		$homepage = $this->navigationsService->getHomepage($this->locale) ?? null;

		$this->getUser()->logout(true);
		$this->redirectUrl($homepage ? $homepage->link : '/');
	}

	protected function createComponent($name): IComponent
	{
		$component = parent::createComponent($name);

		if (!$component) {
			$sl = $this->getComponentFactoriesLocator();

			foreach ($sl->findByTag('dynamicComponent') as $k => $v) {
				if ($v !== $name)
					continue;

				$service = $sl->getService($k);

				if (!$service)
					continue;

				$component = $service->create();
			}
		}

		return $component;
	}
}
