<?php declare(strict_types = 1);

namespace Core\Model\Dao;

class Country
{
	/** @var string */
	protected string $id;

	/** @var string */
	protected string $iso3166_1;

	/** @var string */
	protected string $name;

	public function __construct(string $id, string $iso3166_1, string $name)
	{
		$this->id        = $id;
		$this->iso3166_1 = $iso3166_1;
		$this->name      = $name;
	}

	/**
	 * @return string
	 */
	public function getId(): string { return $this->id; }

	/**
	 * @return string
	 */
	public function getIso31661(): string { return $this->iso3166_1; }

	/**
	 * @return string
	 */
	public function getName(): string { return $this->name; }
}
