<?php declare(strict_types = 1);

namespace Core\Model\UI\DataGrid\DataSource;

use Core\Model\Entities\QueryBuilder;

class DoctrineDataSource extends \Ublaboo\DataGrid\DataSource\DoctrineDataSource
{
	/**
	 * @return \Doctrine\ORM\QueryBuilder|QueryBuilder
	 */
	public function getQueryBuilder()
	{
		return $this->dataSource;
	}

	/**
	 * @param QueryBuilder $qb
	 *
	 * @return $this
	 */
	public function setQueryBuilder(QueryBuilder $qb): self
	{
		$this->dataSource = $qb;

		return $this;
	}

	/**
	 * @param callable $call
	 *
	 * @return $this
	 */
	public function updateQueryBuilder(callable $call): self
	{
		$call($this->dataSource);

		return $this;
	}
}
