<?php declare(strict_types = 1);

namespace Core\Model\UI\DataGrid\Filter;

use Core\Model\UI\Form\BaseContainer;
use Nette\Forms\Controls\BaseControl;
use Ublaboo\DataGrid\Filter\Filter;

class FilterCheckboxNestedList extends Filter
{
	/** @var string */
	protected $template = 'datagrid_filter_checkbox_nested_list.latte';

	/** @var string */
	protected $type = 'radioNestedList';

	/** @var array */
	protected $flatItems = [];

	public function __construct($grid, $key, $name, array $flatItems, $column)
	{
		parent::__construct($grid, $key, $name, $column);

		$this->flatItems = $flatItems;
	}

	/**
	 * @param array $items
	 */
	public function setFlatItems(array $items)
	{
		$this->flatItems = $items;
	}

	public function addToFormContainer(BaseContainer $container)
	{
		$control = $container->addCheckboxNestedList($this->key, $this->name, $this->flatItems);

		$this->addAttributes($container[$this->key]);
	}

	protected function addAttributes($input): BaseControl
	{
		if ($this->grid->hasAutoSubmit()) {
			$input->setHtmlAttribute('data-autosubmit', true);
		} else {
			$input->setHtmlAttribute('data-datagrid-manualsubmit', true);
		}

		foreach ($this->attributes as $key => $value) {
			if (is_array($value)) {
				$value = array_unique($value);
				$value = implode(' ', $value);
			}

			$input->setHtmlAttribute($key, $value);
		}

		return $input;
	}

	public function getCondition(): array
	{
		return [];
	}
}
