<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Core\Model\Helpers\Strings;
use Core\Model\UI\Form\Traits\ChoiceInputTrait;
use Core\Model\UI\Form\Traits\TInputExtend;
use Nette\Forms\Controls\CheckboxList;
use Nette\Utils\Html;

class CheckboxListInput extends CheckboxList
{
	use ChoiceInputTrait;
	use TInputExtend;

	/** @var array */
	protected $eInputs = [];

	public function getControl(): Html
	{
		parent::getControl();
		$fieldset = Html::el('fieldset', [
			'disabled' => $this->isControlDisabled(),
		]);

		foreach ($this->items as $value => $caption) {
			$line = CheckboxInput::makeCheckbox($this->getHtmlName(), $caption, $this->isValueSelected($value),
				$value, false, $this->isValueDisabled($value), $this->getHtmlId($value));
			$line = Html::el('div class="form-control form-control-check"')->setHtml($line);

			$fieldset->addHtml($line)
				->addClass('checkbox-list-input');
		}

		return $fieldset;
	}

	public function getElementInputs()
	{
		if (!$this->eInputs) {
			parent::getControl();

			foreach ($this->items as $value => $caption) {
				$input                   = CheckboxInput::makeCheckbox($this->getHtmlName(), $this->translate($caption), $this->isValueSelected($value),
					$value, false, $this->isValueDisabled($value), $this->getHtmlId($value));
				$input                   = Html::el('div class="form-control form-control-check"')->setHtml($input);
				$this->eInputs[$caption] = $input;
			}
		}

		return $this->eInputs;
	}

	public function getHtmlId($value = ''): string
	{
		return parent::getHtmlId() . ($value ? '-' . Strings::webalize((string) $value) : '');
	}

	public function getValue(): array
	{
		if ($this->getIsMultiLanguage()) {
			foreach ($this->value as $lang => $val) {
				if (!array_key_exists($val, $this->items))
					$this->value[$lang] = null;
			}

			return $this->value ?: [];
		}

		return array_values(array_intersect($this->value, array_keys($this->items)) ?: []) ?: [];
	}
}
