<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Core\Model\UI\Form\Traits\TInputExtend;
use Nette\Utils\Html;
use Nextras;

class DateTimePicker extends Nextras\FormComponents\Controls\DateTimeControl
{
	use TInputExtend;

	public function getControl(): Html
	{
		$wrapper = Html::el('div');
		$control = parent::getControl();

		$control->attrs['class'][] = 'datetimepicker form-control form-control-lg';
		$wrapper->addHtml($control);

		return $wrapper;
	}

}
