const {readdirSync, existsSync} = require('fs');
const path = require('path');

console.clear();

// pshkcms packages folder in vendor
const vendorPackagesFolder = path.resolve(__dirname, '../');
const customPackagesFolder = path.resolve(__dirname, '../../../custom');

const getKey = path => path.split("\\").pop();

// Get all packages
//TODO custom packages
const getPackages = () => {
	const vendorPackages = readdirSync(vendorPackagesFolder)
		.filter(name => {
			if (existsSync(path.join(vendorPackagesFolder, name, 'assets')))
				return true;
			console.warn("WARNING: admin module " + getKey(name) + " does not have /assets folder and it won't be included to the bundle");
			return false
		})
		.map(name => path.join(vendorPackagesFolder, name.toLowerCase()));

	const customPackages = readdirSync(customPackagesFolder)
		.filter(name => {
			if (existsSync(path.join(customPackagesFolder, name, 'assets')))
				return true;
			console.warn("WARNING: custom module " + getKey(name) + " does not have /assets folder and it won't be included to the bundle");
			return false
		})
		.map(name => path.join(customPackagesFolder, name));

	return {vendorPackages, customPackages};
};

// Get all installed stylesheets from packages
const getScss = packages => packages.map(pack => path.resolve(__dirname, `${pack}/assets/admin/src/scss/style.scss`));

// Get all js files from installed packages
const getJs = packages => packages.map(pack => path.resolve(__dirname, `${pack}/assets/admin/src/js/index.js`));

const PACKAGES = getPackages();

// Defining scss files
const adminConfig = {
	entry: {
		login: [path.resolve(__dirname, `${vendorPackagesFolder}/core/assets/admin/src/scss/login.scss`)],
		admin: [path.resolve(__dirname, `${vendorPackagesFolder}/core/assets/admin/src/scss/admin.scss`)],
		modules: [...getScss(PACKAGES.vendorPackages)],
	}
};

if (PACKAGES.customPackages.length > 0)
	adminConfig.entry['custom'] = [...getScss(PACKAGES.customPackages)];

// Output
let logOutputOfPackages = "";

console.log();
console.log("Admin (vendor) packages loaded for compilation: ");

// Defining js index files
PACKAGES.vendorPackages.forEach((dir) => {
	const key = getKey(dir);
	adminConfig.entry['admin'].push(path.join(dir, 'assets', 'admin', 'src', 'js', 'index.js'));
	logOutputOfPackages += key + ', ';
});

console.log(logOutputOfPackages);
console.log();

module.exports = adminConfig;
