<?php declare(strict_types = 1);

namespace Core\Model\Dao;

use Core\Model\Entities\TSeo;
use Core\Model\Providers\ISiteMapImage;
use Core\Model\Providers\ISiteMapUrl;
use Nette\InvalidArgumentException;
use Nette\Utils\DateTime;
use Thepixeldeveloper\Sitemap\Extensions\Image;

class SiteMapUrl implements ISiteMapUrl
{
	use TSeo;

	/** @var DateTime|null */
	protected $modified;

	/** @var Image[] */
	protected $images;

	/**
	 * @return DateTime|null
	 */
	public function getModified() { return $this->modified; }

	public function setModified($modified)
	{
		if ($modified instanceof DateTime || $modified instanceof \DateTime)
			$this->modified = $modified;
	}

	/**
	 * @return Image[]
	 */
	public function getImages()
	{
		return $this->images;
	}

	/**
	 * @param ISiteMapImage[] $images
	 */
	public function setImages($images)
	{
		$this->images = [];

		foreach ($images as $img)
			if ($img instanceof ISiteMapImage)
				$this->images[] = $img;
	}

	/**
	 * @param ISiteMapImage $image
	 */
	public function addImage(ISiteMapImage $image)
	{
		$this->images[] = $image;
	}

}
