
const path = require('path');
const config = require('./admin.config');
const ExtractTextPlugin = require('extract-text-webpack-plugin');
const LiveReloadPlugin = require('webpack-livereload-plugin');
const MiniCssExtractPlugin = require('mini-css-extract-plugin');
const WebpackMessages = require('webpack-messages');
const autoprefixer = require('autoprefixer');
const CopyPlugin = require('copy-webpack-plugin');

module.exports = {
	// Odkaz na node_moduly v core
	stats: 'minimal',
	resolve: {
		alias: {
			AppModules: path.resolve(__dirname, '../../../node_modules/'),
			AdminCore: path.resolve(__dirname,'assets/admin/src'),
			AdminCoreScss: path.resolve(__dirname, 'assets/admin/src/scss'),
			AdminCoreScssShared: path.resolve(__dirname, 'assets/admin/src/scss/shared'),
			AdminCoreJs: path.resolve(__dirname, 'assets/admin/src/js')
		}
	},
	// Definice vstupnich souboru
	entry: config.entry,
	optimization: {
		splitChunks: {
			cacheGroups: {
				commons: {
					name: 'libs',
					chunks: 'initial',
					minChunks: 2
				}
			}
		}
	},
	//Definice výstupních cest
	output: {
		path: path.join(__dirname, '../../../www/assets/admin'),
		filename: 'js/[name].js'
	},
	plugins: [
		new MiniCssExtractPlugin({filename: '_css/[name].css'}),
		new LiveReloadPlugin(),
		new WebpackMessages({
			name: 'Admin package',
			logger: str => console.log(`ADMIN ASSETS BUNDLER >> ${str}`)
		}),
		new CopyPlugin([
			{
				from: 'vendor/pshkcms/core/assets/shared/js',
				to: 'shared/js',
				context: ''
			},
			{
				from: 'vendor/pshkcms/core/assets/img',
				to: 'img',
				context: ''
			},
			{
				from: 'vendor/pshkcms/core/assets/default/ckeditor',
				to: 'default/ckeditor',
				context: ''
			},
			{
				from: 'vendor/pshkcms/core/assets/default/js',
				to: 'default/js',
				context: ''
			}
		])
	],
	module: {
		rules: [
			{
				test: /\.m?js$/,
				exclude: /(node_modules|bower_components)/,
				use: {
					loader: 'babel-loader',
					options: {
						presets: ['@babel/preset-env']
					}
				}
			},
			{
				test: /\.(sa|sc|c)ss$/,
				use: [
					{
						loader: MiniCssExtractPlugin.loader,
						options: {
							sourceMap: true
						}
					},
					{
						loader: 'css-loader?-url', options: {
							sourceMap: true
						}
					},
					{
						loader: 'sass-loader', options: {
							sourceMap:true
						}
					}
				],
			}
		]
	}
};


