<?php declare(strict_types = 1);

namespace Core\DI;

use Core\Components\Navigation\INavigationFactory;
use Kdyby;
use Nette;
use Nette\DI\Helpers as DIHelpers;
use Nette\PhpGenerator\ClassType;

abstract class CompilerExtension extends Nette\DI\CompilerExtension implements Kdyby\Translation\DI\ITranslationProvider, Kdyby\Doctrine\DI\IEntityProvider
{
	protected $extensionName;

	public function __construct()
	{
	}

	public function setConfig(array $config)
	{
		$this->config = $config;
		$builder      = $this->getContainerBuilder();

		if (isset($this->getConfig()['parameters'])) {
			$builder->parameters = array_replace_recursive($this->getConfig()['parameters'], $builder->parameters);
		}

		return $this;
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$builder = $this->getContainerBuilder();

		// Navigation
		//TODO data do navigace poslat pouze 1x (možná až v afterCompile
		$navigation = $builder->getDefinition('core.navigationFactory');
		if ($navigation && isset($builder->parameters['navigation'])) {
			$navigation->addSetup('setData', [$builder->parameters['navigation']]);
		}

		// Decorator
		if (isset($this->getConfig()['decorator'])) {
			foreach ($this->getConfig()['decorator'] as $type => $info) {
				$setups = $info['setup'];
				foreach ($this->findByType($type) as $def) {
					foreach ($setups as $setup) {
						foreach ($setup->arguments as $argK => $argV)
							$setup->arguments[$argK] = DIHelpers::expand($argV, $builder->parameters, true);

						if (is_array($setup))
							$setup = new Nette\DI\Statement(key($setup), array_values($setup));

						$def->addSetup($setup);
					}
				}
			}
		}
	}

	protected function setMapping($mapping)
	{
		$builder = $this->getContainerBuilder();

//				$arr = [];
//				foreach ($mapping as $k => $v) {
//					$override = preg_replace("/(.*)Presenter$/", "$1PresenterOverride", $v);
//
//					if ($override != $v)
//						$arr[$k][] = $override;
//
//					$arr[$k][] = $v;
//				}

		$builder->getDefinition('nette.presenterFactory')->addSetup('setMapping', [$mapping]);
	}

	public function getTranslationResources()
	{
		$ref = new \ReflectionClass(get_class($this->compiler->getExtensions()[$this->name]));

		return [dirname($ref->getFileName()) . DS . '..' . DS . 'lang'];
	}

	public function getEntityMappings()
	{
		$arr = [];

		$ref = new \ReflectionClass(get_class($this->compiler->getExtensions()[$this->name]));

		$path = dirname($ref->getFileName()) . DS . '..' . DS . 'Model' . DS . 'Entities';
		if ($this->getExtensionName() && file_exists($path))
			$arr[$this->getExtensionName() . "\Model\Entities"] = $path;

		return $arr;
	}

	private function getExtensionName()
	{
		if (!$this->extensionName)
			$this->extensionName = explode('\\', get_called_class())[0];

		return $this->extensionName;
	}

	private function findByType($type)
	{
		return array_filter($this->getContainerBuilder()->getDefinitions(), function($def) use ($type) {
			return is_a($def->getType(), $type, true) || is_a($def->getImplement(), $type, true);
		});
	}
}
