<?php declare(strict_types = 1);

namespace Core\FrontModule\Components;

use Core\Model\UI\BaseControl;
use Latte\Engine;
use Nette\Application\UI\ITemplateFactory;
use Nette\Mail\IMailer;
use Nette\Mail\Message;
use Nette\Mail\SendmailMailer;
use Nette\Utils\ArrayHash;

class ContactForm extends BaseControl
{
	/** @var IMailer */
	protected $mailer;

	/** @var ITemplateFactory */
	protected $templateFactory;

	/** @var Message */
	protected $message;

	public function __construct($data, IMailer $mailer, ITemplateFactory $templateFactory)
	{
		$this->message         = new Message();
		$this->mailer          = $mailer;
		$this->templateFactory = $templateFactory;

		$this->setFrom($data['fromEmail'] ?? null, $data['fromName'] ?? null);
		$this->addTo($data['toEmail'] ?? null, $data['toName'] ?? null);
		$this->setSubject($data['subject'] ?? '');

		if (isset($data['bcc'])) {
			foreach (explode(',', $data['bcc']) as $v) {
				$this->message->addBcc(trim($v));
			}
		}
	}

	public function render()
	{
		$this->template->setFile($this->getTemplateFile());
		$this->template->render();
	}

	/*******************************************************************************************************************
	 * ======================== Setters
	 */
	public function setFrom($fromEmail, $fromName = null)
	{
		$this->message->setFrom($fromEmail, $fromName);

		return $this;
	}

	public function addTo($toEmail, $toName = null)
	{
		$this->message->addTo($toEmail, $toName);

		return $this;
	}

	public function setSubject($subject)
	{
		$this->message->setSubject($subject);

		return $this;
	}

	public function signalReceived($signal)
	{
		parent::signalReceived($signal);
	}

	/*******************************************************************************************************************
	 * ======================== Components
	 */

	protected function createComponentForm()
	{
		$form = $this->createForm();
		$form->setAjax();

		$form->addText('name', 'default.contactForm.name')->setPlaceholder('default.contactForm.name')->setRequired();
		$form->addEmail('email', 'default.contactForm.email')->setPlaceholder('default.contactForm.email')->setRequired();
		$form->addText('phone', 'default.contactForm.phone')->setPlaceholder('default.contactForm.phone');
		$form->addTextArea('message', 'default.contactForm.message')->setAttribute('placeholder', $this->t('default.contactForm.message'))->setRequired();
		$form->addCheckbox('gdpr', 'GDPR')->setRequired();

		$form->addSubmit('submit', 'default.contactForm.send');

		$form->onSuccess[] = [$this, 'formOnSuccess'];

		return $form;
	}

	public function formOnSuccess($form, ArrayHash $values)
	{
		try {
			$template = $this->templateFactory->createTemplate();
			$template->setFile(__DIR__ . '/ContactFormEmail.latte');
			$template->setParameters((array) $values);
			$template->setParameters(['subject' => $this->message->getSubject()]);

			$this->message->setHtmlBody($template->renderToString());

			$this->mailer->send($this->message);
			$this->template->okMessage = $this->t('default.contactForm.formOk');
		} catch (\Exception $e) {
			$form->addError($this->t('default.contactForm.sendingError'));

			return false;
		}

		if ($this->getPresenter()->isAjax()) {
			$this->redrawControl('form');
		} else {
			//			$this->redirect('this');
		}
	}
}
