<?php declare(strict_types = 1);

namespace Core\FrontModule\Presenters;

use Contributte\Application\Response\XmlResponse;
use Core\FrontModule\Model\SiteMap;
use Thepixeldeveloper\Sitemap\Drivers\XmlWriterDriver;

/**
 * Class DefaultPresenter
 * @package Core\FrontModule\Presenters
 */
class DefaultPresenter extends BasePresenter
{
	/** @var SiteMap @inject */
	public $siteMapService;

	protected function startup()
	{
		if ($this->action == 'sitemap')
			$this->skipSetInitial = true;

		parent::startup();
	}

	public function actionSitemap($group, $page = 0)
	{
		$siteMap = $this->siteMapService->getSiteMap($group, $page);

		if (!$siteMap)
			$this->error();

		$driver = new XmlWriterDriver();
		$siteMap->accept($driver);

		$this->sendResponse(new XmlResponse($driver->output()));
	}
}
