<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\ArrayHash;

/**
 * Class TSeo
 * @package Core\Model\Entities
 */
trait TSeo
{
	/**
	 * @var array
	 * @ORM\Column(name="seo", type="array", nullable=true)
	 */
	private $seo;

	/**
	 * @param null|string $key
	 *
	 * @return mixed|null
	 */
	public function getSeo($key = null)
	{
		if ($key)
			return $this->seo[$key] ?? null;
		else
			return $this->seo;
	}

	/**
	 * @param string|array $key
	 * @param mixed        $value
	 */
	public function setSeo($key, $value = null)
	{
		if ($key instanceof ArrayHash)
			$key = (array) $key;

		if (is_array($key)) {
			foreach ($key as $k => $v)
				if (is_null($v))
					unset($key[$k]);
			$this->seo = $key;
		} else {
			if ($value) {
				$this->seo[$key] = $value;
			} else {
				unset($this->seo[$key]);
			}
		}

		return $this;
	}
}
