<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Events\Subscriber;
use Kdyby\Translation\Translator;
use Nette\SmartObject;

class TranslateListener implements Subscriber
{
	use SmartObject;
	/** @var Translator */
	protected $translator;

	public function __construct(Translator $translator)
	{
		$this->translator = $translator;
	}

	public function getSubscribedEvents()
	{
		return [];
	}

	/**
	 * @ORM\PostLoad
	 *
	 * @param object             $album
	 * @param LifecycleEventArgs $event
	 */
	public function postLoadHandler($entity, LifecycleEventArgs $event)
	{
		$entity->locale = $this->translator->getDefaultLocale();
	}
}
