<?php declare(strict_types = 1);

namespace Core\Model\Lang;

use Kdyby\Translation\Translator;

/**
 * Class Langs
 * @package Core\Model\Lang
 */
class Langs
{
	/** @var Translator */
	protected $translator;

	/** @var Lang[] */
	protected $langs;

	/**
	 * Langs constructor.
	 *
	 * @param Translator $translator
	 */
	public function __construct(Translator $translator)
	{
		$this->translator = $translator;

		$this->langs['default'] = new Lang(
			$translator->trans('lang.title'),
			$translator->trans('lang.tag'),
			$translator->trans('lang.fullTag')
		);

		foreach ($translator->getAvailableLocales() as $locale) {
			$lang                         = new Lang(
				$translator->trans('title', [], 'lang', $locale),
				$translator->trans('tag', [], 'lang', $locale),
				$translator->trans('fullTag', [], 'lang', $locale)
			);
			$this->langs[$lang->getTag()] = $lang;
		}
	}

	/**
	 * @param $locale
	 *
	 * @return Lang
	 */
	public function getLang($locale = 'default')
	{
		return $this->langs[$locale] ?? $this->langs['default'];
	}

	/**
	 * @return Lang[]
	 */
	public function getLangs($withDefault = true)
	{
		$tmp = $this->langs;

		if (!$withDefault)
			unset($tmp['default']);

		return $tmp;
	}
}
