<?php declare(strict_types = 1);

namespace Core\Model\Mailing;

class MailBuilderFactory
{

	/** @var MailSender */
	protected $sender;

	/** @var TemplateFactory */
	protected $templateFactory;

	/**
	 * @param MailSender      $sender
	 * @param TemplateFactory $templateFactory
	 */
	public function __construct(MailSender $sender, TemplateFactory $templateFactory)
	{
		$this->sender          = $sender;
		$this->templateFactory = $templateFactory;
	}

	/**
	 * @return MailBuilder
	 */
	public function create()
	{
		$mail = new MailBuilder($this->sender);
		$mail->setTemplate($this->templateFactory->create());

		return $mail;
	}

}