<?php declare(strict_types = 1);

namespace Core\Model\Router;

use Kdyby\Translation\Translator;

class RouteHelper
{
	/** @var Translator */
	protected $translator;

	public function __construct(Translator $translator)
	{
		$this->translator = $translator;
	}

	public function createRoute($mask, $metadata = [], $flags = 0, $locale = null)
	{
		if (!$locale) {
			$locale = $this->translator->getDefaultLocale();
		}

		return new Route($mask, $metadata, $flags, $locale);
	}

	public function createAdminRoute($mask, $metadata = [], $flags = 0, $locale = null)
	{
		if (!$locale) {
			$locale = $this->translator->getDefaultLocale();
		}

		return new RouteAdmin($mask, $metadata, $flags, $locale);
	}
}